package com.example.gpiotest;

import java.io.IOException;
import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.Toast;
import android.hardware.gpio.GpioManager;
import android.hardware.gpio.GpioPort;
public class MainActivity extends Activity {
	private GpioManager mGpioManager;
    private GpioPort mGpioPort;
    private Spinner spOUT1; 
    private Spinner spOUT2;
    private Spinner spOUT3;
    private Spinner spOUT4;
    private Spinner spIN1;
    private Spinner spIN2;
    private Spinner spIN3;
    private Spinner spIN4;
    Button btGet;
    Button btSet;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
	    mGpioManager = (GpioManager)getSystemService("gpio");
	    initgpio();
	    spOUT1 =(Spinner)findViewById(R.id.out1_spinner);
	    spOUT2 =(Spinner)findViewById(R.id.out2_spinner);
	    spOUT3 =(Spinner)findViewById(R.id.out3_spinner);
	    spOUT4 =(Spinner)findViewById(R.id.out4_spinner);
	    
	    spIN1 =(Spinner)findViewById(R.id.in1_spinner);
	    spIN2 =(Spinner)findViewById(R.id.in2_spinner);
	    spIN3 =(Spinner)findViewById(R.id.in3_spinner);
	    spIN4 =(Spinner)findViewById(R.id.in4_spinner);
	    
		ArrayAdapter<CharSequence> adapter1 =  ArrayAdapter.createFromResource(this, R.array.power_select, android.R.layout.simple_spinner_item);
		adapter1.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		spOUT1.setAdapter(adapter1); 
		spOUT1.setSelection(0, true);
		spOUT2.setAdapter(adapter1); 
		spOUT2.setSelection(0, true);
		spOUT3.setAdapter(adapter1); 
		spOUT3.setSelection(0, true);
		spOUT4.setAdapter(adapter1); 
		spOUT4.setSelection(0, true);
     	
		spIN1.setAdapter(adapter1); 
		spIN1.setSelection(0, true);
		spIN2.setAdapter(adapter1); 
		spIN2.setSelection(0, true);
		spIN3.setAdapter(adapter1); 
		spIN3.setSelection(0, true);
		spIN4.setAdapter(adapter1); 
		spIN4.setSelection(0, true);
		
		btSet = (Button)findViewById(R.id.button_set);
		btSet.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				try{
					//4
					int out1 =  spOUT1.getSelectedItemPosition();
					int out2 =  spOUT2.getSelectedItemPosition();
					int out3 =  spOUT3.getSelectedItemPosition();
					int out4 =  spOUT4.getSelectedItemPosition();
					mGpioPort = mGpioManager.obtainGpioPortControl("GPIO19");
			         if (mGpioPort != null) {
			             int gpio_num = mGpioManager.getGpioValue("GPIO19");
			             mGpioPort.set_data(gpio_num,out1);
		                 mGpioPort.gpio_init();
		                 mGpioPort = null;
			         }
			         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO82");
			         if (mGpioPort != null) {
			             int gpio_num = mGpioManager.getGpioValue("GPIO82");
			             mGpioPort.set_data(gpio_num,out2);
		                 mGpioPort.gpio_init();
		                 mGpioPort = null;
			         }
			         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO66");
			         if (mGpioPort != null) {
			             int gpio_num = mGpioManager.getGpioValue("GPIO66");
			             mGpioPort.set_data(gpio_num,out3);
		                 mGpioPort.gpio_init();
		                 mGpioPort = null;
			         }
			         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO83");
			         if (mGpioPort != null) {
			             int gpio_num = mGpioManager.getGpioValue("GPIO83");
			             mGpioPort.set_data(gpio_num,out4);
		                 mGpioPort.gpio_init();
		                 mGpioPort = null;
			         }
				}catch(Exception ex)
				{
					Toast.makeText(getApplicationContext(),getString(R.string.info_set_failed),Toast.LENGTH_SHORT).show();
				}
			}
		});
		
		btGet = (Button)findViewById(R.id.button_get);
		btGet.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				
				try{
					//4
					mGpioPort = mGpioManager.obtainGpioPortControl("GPIO44");
			         if (mGpioPort != null) {
			             int gpio_num = mGpioManager.getGpioValue("GPIO44");
			             int data = mGpioPort.get_data(gpio_num);
		                 spIN1.setSelection(data,true);	
		                 mGpioPort.gpio_init();
		                 mGpioPort = null;
			         }
			         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO43");
			         if (mGpioPort != null) {
			             int gpio_num = mGpioManager.getGpioValue("GPIO43");
			             int data = mGpioPort.get_data(gpio_num);
		                 spIN2.setSelection(data,true);	
		                 mGpioPort.gpio_init();
		                 mGpioPort = null;
			         }
			         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO68");
			         if (mGpioPort != null) {
			             int gpio_num = mGpioManager.getGpioValue("GPIO68");
			             int data = mGpioPort.get_data(gpio_num);
		                 spIN3.setSelection(data,true);	
		                 mGpioPort.gpio_init();
		                 mGpioPort = null;
			         }
			         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO65");
			         if (mGpioPort != null) {
			             int gpio_num = mGpioManager.getGpioValue("GPIO65");
			             int data = mGpioPort.get_data(gpio_num);
		                 spIN4.setSelection(data,true);	
		                 mGpioPort.gpio_init();
		                 mGpioPort = null;
			         }
				}catch(Exception ex)
				{
					Toast.makeText(getApplicationContext(),getString(R.string.info_get_failed),Toast.LENGTH_SHORT).show();
				}
			}
		});
	}
	private void initgpio()
	{
		try{
			//4
			mGpioPort = mGpioManager.obtainGpioPortControl("GPIO19");
	         if (mGpioPort != null) {
	             int gpio_num = mGpioManager.getGpioValue("GPIO19");
	             mGpioPort.set_mode(gpio_num,0);
	             mGpioPort.set_dir(gpio_num,1);
	             mGpioPort.gpio_init();
                 mGpioPort = null;
	         }
	         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO82");
	         if (mGpioPort != null) {
	             int gpio_num = mGpioManager.getGpioValue("GPIO82");
	             mGpioPort.set_mode(gpio_num,0);
	             mGpioPort.set_dir(gpio_num,1);
	             mGpioPort.gpio_init();
                 mGpioPort = null;
	         }
	         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO66");
	         if (mGpioPort != null) {
	             int gpio_num = mGpioManager.getGpioValue("GPIO66");
	             mGpioPort.set_mode(gpio_num,0);
	             mGpioPort.set_dir(gpio_num,1);
	             mGpioPort.gpio_init();
                 mGpioPort = null;
	         }
	         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO83");
	         if (mGpioPort != null) {
	             int gpio_num = mGpioManager.getGpioValue("GPIO83");
	             mGpioPort.set_mode(gpio_num,0);
	             mGpioPort.set_dir(gpio_num,1);
	             mGpioPort.gpio_init();
                 mGpioPort = null;
	         }
	         
	       //4
			mGpioPort = mGpioManager.obtainGpioPortControl("GPIO44");
	         if (mGpioPort != null) {
	             int gpio_num = mGpioManager.getGpioValue("GPIO44");
	             mGpioPort.set_mode(gpio_num,0);
	             mGpioPort.set_dir(gpio_num,0);
	             mGpioPort.gpio_init();
                 mGpioPort = null;
	         }
	         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO43");
	         if (mGpioPort != null) {
	             int gpio_num = mGpioManager.getGpioValue("GPIO43");
	             mGpioPort.set_mode(gpio_num,0);
	             mGpioPort.set_dir(gpio_num,0);
	             mGpioPort.gpio_init();
                 mGpioPort = null;
	         }
	         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO68");
	         if (mGpioPort != null) {
	             int gpio_num = mGpioManager.getGpioValue("GPIO68");
	             mGpioPort.set_mode(gpio_num,0);
	             mGpioPort.set_dir(gpio_num,0);
	             mGpioPort.gpio_init();
                 mGpioPort = null;
	         }
	         mGpioPort = mGpioManager.obtainGpioPortControl("GPIO65");
	         if (mGpioPort != null) {
	             int gpio_num = mGpioManager.getGpioValue("GPIO65");
	             mGpioPort.set_mode(gpio_num,0);
	             mGpioPort.set_dir(gpio_num,0);
	             mGpioPort.gpio_init();
                 mGpioPort = null;
	         }
		}catch(Exception ex)
		{
			Toast.makeText(getApplicationContext(),getString(R.string.info_init_failed),Toast.LENGTH_SHORT).show();
		}
		 
	}
	
	@Override
    public void onResume() {
        super.onResume();
        
    }
	
	@Override
	public void onDestroy() {
	     super.onDestroy();
	}
}
